package com.tyoma.resume;

import javax.servlet.http.*;
import javax.servlet.*;
import java.util.*;
import java.io.*;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.sax.SAXResult;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.MimeConstants;
import java.net.*;

public class xmlResume extends HttpServlet {
    
    HttpServletRequest request;
    HttpServletResponse response;
    
    public void doGet(HttpServletRequest request, HttpServletResponse response)
    throws javax.servlet.ServletException, java.io.IOException {
        
        this.request = request;
        this.response = response;
        String mimeType = "text/xml";
        String xsltUrl = null;
        String type = request.getParameter("type");
        if (type != null && type.trim().length() > 0) {
            if (type.equals(".pdf")) {
                mimeType = MimeConstants.MIME_PDF;
                xsltUrl = "so_pdf.xsl";
            }
            if (type.equals(".rtf")) {
                mimeType = MimeConstants.MIME_RTF;
                xsltUrl = "so_rtf.xsl";
            }
            if (type.equals(".txt")) {
                mimeType = "text/html";
                xsltUrl = "txt.xsl";
            }
            if (type.equals(".html")) {
                mimeType = "text/html";
                xsltUrl = "print.xsl";
            }
            if (type.equals(".htm")) {
                mimeType = "text/xml";
                xsltUrl = "htm.xsl";
            }
            if (type.equals(".xml")) {
                mimeType = "text/xml";
                xsltUrl = "xml.xsl";
            }
        }
        response.setContentType(mimeType+ "; charset=ISO-8859-1");
        try {
            System.out.println("FOP ExampleXML2PDF\n");
            URL sourceURL = getSourceURL(request.getParameter("source"));
            if (xsltUrl == null) {
                URLConnection conn = sourceURL.openConnection();
                conn.connect();
                InputStreamReader file = new InputStreamReader(conn.getInputStream());
                BufferedReader buff = new BufferedReader(file);
                java.io.PrintWriter out = response.getWriter();
                java.io.FileWriter outFile = new FileWriter("/netapp/home/artyom/ROOT/output.xml");
                String line = " ";
                while (true) {
                    line = buff.readLine();
                    if (line == null) break;
                    out.println(line);
                    outFile.write(line +"\n");
                    System.out.print(line +"\n");
                }
                out.close();
                outFile.flush();
            }
            else {
                Source xsltfile = new StreamSource(new URL("http://www.tyoma.com/scripts/resume/"+ xsltUrl).openStream());
                Source xmlfile = new StreamSource(sourceURL.openStream());
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer(xsltfile);
                if (mimeType.startsWith("text")) {
                    java.io.StringWriter stringWriter = new StringWriter(1000);
                    transformer.transform(xmlfile, new StreamResult(stringWriter));
                    StringBuffer stringBuffer = stringWriter.getBuffer();
                    //                int crlf = stringBuffer.indexOf("\n")+1;
                    //                stringBuffer.delete(0,crlf);
                    java.io.PrintWriter out = response.getWriter();
                    out.print(stringBuffer.toString());
                    out.close();
                }
                else {
                    OutputStream out = response.getOutputStream();
                    out = new java.io.BufferedOutputStream(out);
                    Fop fop = new Fop(mimeType);
                    fop.setOutputStream(out);
                    transformer.setParameter("versionParam", "2.0");
                    Result res = new SAXResult(fop.getDefaultHandler());
                    System.out.println("before transform");
                    transformer.transform(xmlfile, res);
                    out.close();
                }
            }
            System.out.println("Success!");
        } catch (Exception e) {
            e.printStackTrace(System.err);
            java.io.PrintWriter out = response.getWriter();
            response.setContentType("text/html; charset=ISO-8859-1");
            out.print("<h2>" + e.toString() +"</h2>");
            e.printStackTrace(out);
            out.close();
        }
    }
    private URL getSourceURL(String urlString) throws MalformedURLException {
        if (urlString == null || urlString.trim().length() == 0) urlString ="source.xml";
        if (!urlString.startsWith("/") && !urlString.toLowerCase().startsWith("http")) urlString ="/scripts/resume/" + urlString;
        if (urlString.startsWith("/") && request.getServerPort() != 80) urlString = ":" + request.getServerPort() + urlString;
        if (!urlString.toLowerCase().startsWith("http")) urlString = "http://" + request.getServerName() + urlString;
        return new URL(urlString);
    }
}

